/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.security;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.security.HscLoginModuleCache;
import com.ibm.hsc.security.HscPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class HscLoginModule
implements LoginModule {
    private Subject hscSubject;
    private String username;
    private CallbackHandler cbHandler;
    private final int HLModuleId = 11;
    private String[] roleList = null;
    private boolean loginOK = false;
    private boolean commitOK = false;
    private static AcaClient m_acaCl = null;
    private static Hashtable userpwCache = new Hashtable(29);
    private short oldestTSObjIndex = 0;
    private short eqObjIndex = 0;

    public static AcaClient getAcaClientHandle() {
        if (m_acaCl == null) {
            userpwCache.clear();
            try {
                m_acaCl = new AcaClient();
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException) {
                    m_acaCl = null;
                    System.err.println("HscLogin: failed to get AcaClient Handle.\n");
                }
                System.err.println("HscLogin: getAcaClientHandle failed\n");
                throwable.printStackTrace();
            }
        }
        return m_acaCl;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.hscSubject = subject;
        this.cbHandler = callbackHandler;
        PIHmcAccessUtils.HSC_ACCESS_CONTROL = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        char[] cArray;
        if (this.cbHandler == null) {
            throw new LoginException("HscLogin: Null CallbackHandler!");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("login: "), new PasswordCallback("password: ", false)};
        String string = null;
        try {
            this.cbHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            char[] cArray2 = ((PasswordCallback)callbackArray[1]).getPassword();
            if (cArray2 == null) {
                cArray2 = new char[]{};
            }
            cArray = new char[cArray2.length];
            System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            System.out.println("HscLogin: IOException occured during getting password");
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            System.out.println("HscLogin: UnsupportedCallbackException in get-password");
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString());
        }
        Hashtable hashtable = userpwCache;
        synchronized (hashtable) {
            int n = -1;
            String string2 = new String(cArray);
            String string3 = this.username + cArray;
            HscLoginModuleCache hscLoginModuleCache = (HscLoginModuleCache)userpwCache.get(string3);
            if (hscLoginModuleCache == null) {
                if (cArray[0] == 'S' && cArray[1] == 'T') {
                    n = AcaUtils.isValidUser((String)this.username, (String)string2);
                }
                if (n != 0) {
                    n = this.authenticate(this.username, string2);
                }
                if (n == 0) {
                    hscLoginModuleCache = this.createObjToCache(this.username);
                    if (hscLoginModuleCache == null) {
                        this.loginOK = false;
                        string = "(" + this.username + ") Access Manager is down!";
                        throw new FailedLoginException(string);
                    }
                    if (userpwCache.size() >= 21) {
                        userpwCache.clear();
                    }
                    userpwCache.put(string3, hscLoginModuleCache);
                    this.loginOK = true;
                    return true;
                }
                string = "User (" + this.username + ") Authentication failed!";
                System.out.println("HscLogin: " + string + " (no-cache)");
                this.loginOK = false;
                throw new FailedLoginException(string);
            }
            this.roleList = hscLoginModuleCache.getRoleList();
            if (!hscLoginModuleCache.isStillValid()) {
                if (cArray[0] == 'S' && cArray[1] == 'T') {
                    n = AcaUtils.isValidUser((String)this.username, (String)string2);
                }
                if (n != 0) {
                    n = this.authenticate(this.username, string2);
                }
                if (n == 0) {
                    hscLoginModuleCache = this.createObjToCache(this.username);
                    if (hscLoginModuleCache == null) {
                        this.loginOK = false;
                        string = "(" + this.username + ") Access Manager is down.";
                        throw new FailedLoginException(string);
                    }
                    userpwCache.put(string3, hscLoginModuleCache);
                    this.loginOK = true;
                    return true;
                }
                string = "User (" + this.username + ") Authentication failed!";
                System.out.println("HscLogin: " + string + "(cached)");
                this.loginOK = false;
                throw new FailedLoginException(string);
            }
            this.loginOK = true;
            return true;
        }
    }

    public HscLoginModuleCache createObjToCache(String string) {
        AcaClient acaClient = HscLoginModule.getAcaClientHandle();
        if (acaClient == null) {
            return null;
        }
        this.roleList = acaClient.GetRoleAncestors(string);
        if (this.roleList == null) {
            return null;
        }
        Date date = new Date();
        long l = date.getTime();
        HscLoginModuleCache hscLoginModuleCache = new HscLoginModuleCache(this.roleList, l);
        return hscLoginModuleCache;
    }

    public boolean commit() throws LoginException {
        if (!this.loginOK) {
            return false;
        }
        if (this.roleList == null) {
            AcaClient acaClient = HscLoginModule.getAcaClientHandle();
            if (acaClient == null) {
                return false;
            }
            this.roleList = acaClient.GetRoleAncestors(this.username);
        }
        this.addPrincipals(this.username);
        this.commitOK = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.loginOK) {
            System.out.println("HscAbort: Aborted login after authentication failure");
            return false;
        }
        if (this.loginOK && !this.commitOK) {
            System.out.println("HscAbort: Aborted login for user " + this.username);
            this.loginOK = false;
            this.username = null;
            this.roleList = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.removePrincipals();
        System.out.println("HscLogout: Logged out user " + this.username);
        this.loginOK = false;
        this.commitOK = false;
        this.username = null;
        this.roleList = null;
        return true;
    }

    private int addPrincipals(String string) {
        int n = 0;
        if (this.roleList == null) {
            return n;
        }
        n = this.roleList.length;
        Set<Principal> set = this.hscSubject.getPrincipals();
        for (int i = 0; i < n; i += 2) {
            String string2 = this.roleList[i];
            String string3 = this.roleList[i + 1];
            HscPrincipal hscPrincipal = string.equals("ccfw") ? new HscPrincipal(string3, string2, "hscroot") : new HscPrincipal(string3, string2, string);
            set.add(hscPrincipal);
        }
        return n;
    }

    private int removePrincipals() {
        int n = 0;
        if (this.roleList == null) {
            return n;
        }
        n = this.roleList.length;
        Set<Principal> set = this.hscSubject.getPrincipals();
        for (int i = 0; i < n; ++i) {
            HscPrincipal hscPrincipal = new HscPrincipal(this.roleList[i]);
            set.remove(hscPrincipal);
        }
        return n;
    }

    private native int authenticate(String var1, String var2);

    static {
        try {
            System.loadLibrary("hsclogin");
            m_acaCl = new AcaClient();
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                m_acaCl = null;
                System.out.println("HscLogin: Initialize AcaClient failed.");
            }
            System.out.println("HscLogin: Throwable occured in static block\n");
            throwable.printStackTrace();
        }
    }
}

